############################################################################
#version history

#v1 - original code to ingest CTI final scores and cyano results and merge together
############################################################################
# Load necessary libraries
library(readxl)
library(dplyr)
library(writexl)
library(tidyr)

############################################################################
#user specifications
setwd("C:/Users/Michael Palmer/Association to Preserve Cape Cod, Inc/Programs & Projects - STATE of the Waters/Data Analysis/CCC_data_processing/final_2015_2024")


CTI_results <- read_excel("outputs/CCC_CTI_output_2025.xlsx", sheet="Final_grades")
past_scores <- read_excel("outputs/CTI_all_scores_comparison_2021_to_2024.xlsx")
cyano_results <- read_excel("Pond_Cyano_Score_2025report_2024data.xlsx")
ponds_master <- read_excel("CCC_Ponds_datafile_20250709.xlsx")

cyano_results <- cyano_results %>%
  rename(
    Pond_Name = 1,
    CCC_GIS_ID = 2,
    Town = 3,
    Highest_cyano_2024 = 4,
    Cyano_status_2024 = 5
  )

joined_results <- full_join(
  select(cyano_results, CCC_GIS_ID, Highest_cyano_2024, Cyano_status_2024),
  select(CTI_results, CCC_GIS_ID, TSI_5yr_avg, Years_included, TSI_grade),
  by = "CCC_GIS_ID"
)

past_scores_wide <- past_scores %>%
  select(CCC_GIS_ID, Year, TSI_5yr_avg) %>%  # keep only the necessary columns
  pivot_wider(
    names_from = Year,
    values_from = TSI_5yr_avg,
    names_prefix = "TSI_avg_"
  )

joined_results <- joined_results %>%
  left_join(
    past_scores_wide %>% select(CCC_GIS_ID, starts_with("TSI_avg_")),
    by = "CCC_GIS_ID"
  )

joined_results <- joined_results %>%
  select(
    CCC_GIS_ID,
    Highest_cyano_2024,
    Cyano_status_2024,
    TSI_avg_2021,
    TSI_avg_2022,
    TSI_avg_2023,
    TSI_avg_2024,
    TSI_5yr_avg,
    Years_included,
    TSI_grade
  )

final_results <- joined_results %>%
  left_join(
    ponds_master %>%
      select(CCC_GIS_ID, Name, Village, Town, Latitude, Longitude, Acres, Great_Pond, Inlet, Outlet),
    by = "CCC_GIS_ID"
  ) %>%
  relocate(Name, Village, Town, Latitude, Longitude, Acres, Great_Pond, Inlet, Outlet, .after = CCC_GIS_ID)

missing_coords <- final_results %>%
  filter(is.na(Latitude) | is.na(Longitude))

final_results <- final_results %>%
  mutate(
    Final_grade = case_when(
      str_detect(Cyano_status_2024, "Unacceptable") | str_detect(TSI_grade, "Unacceptable") ~ 
        "Unacceptable: requires immediate restoration",
      is.na(Cyano_status_2024) & is.na(TSI_grade) ~ NA_character_,
      TRUE ~ "Acceptable: requires ongoing protection"
    )
  ) %>%
  mutate(TSI_5yr_avg = round(TSI_5yr_avg, 1)) %>%
  mutate(
    Criteria = case_when(
      is.na(Cyano_status_2024) & is.na(TSI_grade) ~ NA_character_,
      !is.na(Cyano_status_2024) & !is.na(TSI_grade) ~ "CTI and Cyanobacteria",
      !is.na(TSI_grade) & is.na(Cyano_status_2024) ~ "CTI Only",
      is.na(TSI_grade) & !is.na(Cyano_status_2024) ~ "Cyanobacteria Only"
    )
  ) %>%
  mutate(
    Final_grade = coalesce(as.character(Final_grade), "Insufficient Data")
  )


write_xlsx(final_results, path = "outputs/SOTW_freshwater_2025_final_results.xlsx")
